/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import DocumentService from"@typo3/core/document-service.js";import $ from"jquery";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import PasswordStrength from"@typo3/install/module/password-strength.js";import InfoBox from"@typo3/install/renderable/info-box.js";import ProgressBar from"@typo3/install/renderable/progress-bar.js";import Severity from"@typo3/install/renderable/severity.js";import"@typo3/backend/element/icon-element.js";import{selector}from"@typo3/core/literals.js";class Installer{constructor(){this.selectorBody=".t3js-body",this.selectorModuleContent=".t3js-module-content",this.selectorMainContent=".t3js-installer-content",this.selectorProgressBar=".t3js-installer-progress",this.selectorProgressBarSteps=".t3js-installer-progress-steps",this.selectorDatabaseConnectOutput=".t3js-installer-databaseConnect-output",this.selectorDatabaseSelectOutput=".t3js-installer-databaseSelect-output",this.selectorDatabaseDataOutput=".t3js-installer-databaseData-output",this.initializeEvents(),DocumentService.ready().then((()=>{this.initialize()}))}initializeEvents(){$(document).on("click",".t3js-installer-environmentFolders-retry",(e=>{e.preventDefault(),this.showEnvironmentAndFolders()})),$(document).on("click",".t3js-installer-environmentFolders-execute",(e=>{e.preventDefault(),this.executeEnvironmentAndFolders()})),$(document).on("click",".t3js-installer-databaseConnect-execute",(e=>{e.preventDefault(),this.executeDatabaseConnect()})),$(document).on("click",".t3js-installer-databaseSelect-execute",(e=>{e.preventDefault(),this.executeDatabaseSelect()})),$(document).on("click",".t3js-installer-databaseData-execute",(e=>{e.preventDefault(),this.executeDatabaseData()})),$(document).on("click",".t3js-installer-defaultConfiguration-execute",(e=>{e.preventDefault(),this.executeDefaultConfiguration()})),$(document).on("click",".t3-install-form-password-toggle",(e=>{e.preventDefault();const t=$(e.currentTarget),s=$(t.data("toggleTarget"));"invisible"===t.attr("data-toggle-state")?(t.attr("data-toggle-state","visible"),s.attr("type","text")):(t.attr("data-toggle-state","invisible"),s.attr("type","password"))})),$(document).on("keyup",".t3-install-form-password-strength",(()=>{PasswordStrength.initialize(".t3-install-form-password-strength")})),$(document).on("change","#t3js-connect-database-driver",(e=>{const t=$(e.currentTarget).val();$(".t3-install-driver-data").hide(),$(".t3-install-driver-data input").attr("disabled","disabled"),$(selector`#${t} input`).attr("disabled",null),$(selector`#${t}`).show()}))}initialize(){this.setProgress(0),this.getMainLayout()}getUrl(e){let t=location.href;return t=t.replace(location.search,""),void 0!==e&&(t=t+"?install[action]="+e),t}setProgress(e){const t=document.querySelector(this.selectorProgressBar);if(null===t)return;const s=document.querySelector(this.selectorProgressBarSteps);let a=0;0!==e&&(a=e/5*100,t.setAttribute("aria-label",e+" of 5"),t.querySelector(".progress-bar").textContent=a+"%",s.querySelector(".progress-steps").textContent=e+" of 5"),t.setAttribute("aria-valuenow",a.toString());t.querySelector(".progress-bar").style.width=a+"%"}getMainLayout(){new AjaxRequest(this.getUrl("mainLayout")).get({cache:"no-cache"}).then((async e=>{const t=await e.resolve();$(this.selectorBody).empty().append(t.html),this.checkInstallerAvailable()}))}checkInstallerAvailable(){new AjaxRequest(this.getUrl("checkInstallerAvailable")).get({cache:"no-cache"}).then((async e=>{(await e.resolve()).success?this.checkEnvironmentAndFolders():this.showInstallerNotAvailable()}))}showInstallerNotAvailable(){const e=$(this.selectorMainContent);new AjaxRequest(this.getUrl("showInstallerNotAvailable")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success&&e.empty().append(s.html)}))}checkEnvironmentAndFolders(){this.setProgress(1),new AjaxRequest(this.getUrl("checkEnvironmentAndFolders")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkTrustedHostsPattern():this.showEnvironmentAndFolders()}))}showEnvironmentAndFolders(){const e=$(this.selectorMainContent);new AjaxRequest(this.getUrl("showEnvironmentAndFolders")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();if(!0===s.success){e.empty().html(s.html);const t=$(".t3js-installer-environment-details");let a=!1;Array.isArray(s.environmentStatusErrors)&&s.environmentStatusErrors.forEach((e=>{a=!0;const s=InfoBox.render(e.severity,e.title,e.message);t.append(s)})),Array.isArray(s.environmentStatusWarnings)&&s.environmentStatusWarnings.forEach((e=>{a=!0;const s=InfoBox.render(e.severity,e.title,e.message);t.append(s)})),Array.isArray(s.structureErrors)&&s.structureErrors.forEach((e=>{a=!0;const s=InfoBox.render(e.severity,e.title,e.message);t.append(s)})),a?(t.show(),$(".t3js-installer-environmentFolders-bad").show()):$(".t3js-installer-environmentFolders-good").show()}}))}executeEnvironmentAndFolders(){new AjaxRequest(this.getUrl("executeEnvironmentAndFolders")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success&&this.checkTrustedHostsPattern()}))}checkTrustedHostsPattern(){new AjaxRequest(this.getUrl("checkTrustedHostsPattern")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.executeSilentConfigurationUpdate():this.executeAdjustTrustedHostsPattern()}))}executeAdjustTrustedHostsPattern(){new AjaxRequest(this.getUrl("executeAdjustTrustedHostsPattern")).get({cache:"no-cache"}).then((()=>{this.executeSilentConfigurationUpdate()}))}executeSilentConfigurationUpdate(){new AjaxRequest(this.getUrl("executeSilentConfigurationUpdate")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.executeSilentTemplateFileUpdate():this.executeSilentConfigurationUpdate()}))}executeSilentTemplateFileUpdate(){new AjaxRequest(this.getUrl("executeSilentTemplateFileUpdate")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseConnect():this.executeSilentTemplateFileUpdate()}))}checkDatabaseConnect(){this.setProgress(2),new AjaxRequest(this.getUrl("checkDatabaseConnect")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseSelect():this.showDatabaseConnect()}))}showDatabaseConnect(){const e=$(this.selectorMainContent);new AjaxRequest(this.getUrl("showDatabaseConnect")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success&&(e.empty().html(s.html),$("#t3js-connect-database-driver").trigger("change"))}))}executeDatabaseConnect(){const e=$(this.selectorDatabaseConnectOutput),t={"install[action]":"executeDatabaseConnect","install[token]":$(this.selectorModuleContent).data("installer-database-connect-execute-token")};for(const e of $(this.selectorBody+" form").serializeArray())t[e.name]=e.value;new AjaxRequest(this.getUrl()).post(t).then((async t=>{const s=await t.resolve();!0===s.success?this.checkDatabaseSelect():Array.isArray(s.status)&&(e.empty(),s.status.forEach((t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.append(s)})))}))}checkDatabaseSelect(){this.setProgress(3),new AjaxRequest(this.getUrl("checkDatabaseSelect")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseData():this.showDatabaseSelect()}))}showDatabaseSelect(){const e=$(this.selectorMainContent);new AjaxRequest(this.getUrl("showDatabaseSelect")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success&&e.empty().html(s.html)}))}executeDatabaseSelect(){const e=$(this.selectorDatabaseSelectOutput),t={"install[action]":"executeDatabaseSelect","install[token]":$(this.selectorModuleContent).data("installer-database-select-execute-token")};for(const e of $(this.selectorBody+" form").serializeArray())t[e.name]=e.value;new AjaxRequest(this.getUrl()).post(t).then((async t=>{const s=await t.resolve();!0===s.success?this.checkDatabaseRequirements():Array.isArray(s.status)&&s.status.forEach((t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.empty().append(s)}))}))}checkDatabaseRequirements(){const e=$(this.selectorDatabaseSelectOutput),t={"install[action]":"checkDatabaseRequirements","install[token]":$(this.selectorModuleContent).data("installer-database-check-requirements-execute-token")};for(const e of $(this.selectorBody+" form").serializeArray())t[e.name]=e.value;new AjaxRequest(this.getUrl()).post(t).then((async t=>{const s=await t.resolve();!0===s.success?this.checkDatabaseData():Array.isArray(s.status)&&(e.empty(),s.status.forEach((t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.append(s)})))}))}checkDatabaseData(){this.setProgress(4),new AjaxRequest(this.getUrl("checkDatabaseData")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.showDefaultConfiguration():this.showDatabaseData()}))}showDatabaseData(){const e=$(this.selectorMainContent);new AjaxRequest(this.getUrl("showDatabaseData")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success&&e.empty().html(s.html)}))}executeDatabaseData(){const e=$(this.selectorDatabaseDataOutput),t={"install[action]":"executeDatabaseData","install[token]":$(this.selectorModuleContent).data("installer-database-data-execute-token")};for(const e of $(this.selectorBody+" form").serializeArray())t[e.name]=e.value;const s=ProgressBar.render(Severity.loading,"Loading...","");e.empty().append(s),new AjaxRequest(this.getUrl()).post(t).then((async t=>{const s=await t.resolve();!0===s.success?this.showDefaultConfiguration():Array.isArray(s.status)&&(e.empty(),s.status.forEach((t=>{const s=InfoBox.render(t.severity,t.title,t.message);e.append(s)})))}))}showDefaultConfiguration(){const e=$(this.selectorMainContent);this.setProgress(5),new AjaxRequest(this.getUrl("showDefaultConfiguration")).get({cache:"no-cache"}).then((async t=>{const s=await t.resolve();!0===s.success&&e.empty().html(s.html)}))}executeDefaultConfiguration(){const e={"install[action]":"executeDefaultConfiguration","install[token]":$(this.selectorModuleContent).data("installer-default-configuration-execute-token")};for(const t of $(this.selectorBody+" form").serializeArray())e[t.name]=t.value;new AjaxRequest(this.getUrl()).post(e).then((async e=>{const t=await e.resolve();top.location.href=t.redirect}))}}export default new Installer;