/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var __decorate=function(t,e,o,r){var n,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,o):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,o,r);else for(var l=t.length-1;l>=0;l--)(n=t[l])&&(i=(a<3?n(i):a>3?n(e,o,i):n(e,o))||i);return a>3&&i&&Object.defineProperty(e,o,i),i};import{customElement,property}from"lit/decorators.js";import{css,html,LitElement}from"lit";import Modal from"@typo3/backend/modal.js";import{SeverityEnum}from"@typo3/backend/enum/severity.js";import DeferredAction from"@typo3/backend/action-button/deferred-action.js";import AjaxDataHandler from"@typo3/backend/ajax-data-handler.js";import Viewport from"@typo3/backend/viewport.js";let DeleteButton=class extends LitElement{connectedCallback(){super.connectedCallback(),this.hasAttribute("role")||this.setAttribute("role","button"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),this.addEventListener("click",this.showConfirmationModal)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.showConfirmationModal)}render(){return html`<slot></slot>`}showConfirmationModal(){Modal.advanced({content:this.modalContent,title:this.modalTitle,severity:SeverityEnum.warning,size:Modal.sizes.small,buttons:[{text:this.cancelButtonLabel||"Close",btnClass:"btn-default",trigger:function(){Modal.dismiss()}},{text:this.okButtonLabel||"OK",btnClass:"btn-warning",action:new DeferredAction((async()=>{await this.deleteRecord()}))}]})}async deleteRecord(){const t=AjaxDataHandler.process(`cmd[sys_note][${this.uid}][delete]=1`);return t.then((()=>{Viewport.ContentContainer.setUrl(this.returnUrl)})),t}};DeleteButton.styles=[css`:host { cursor: pointer; appearance: button; }`],__decorate([property({type:Number})],DeleteButton.prototype,"uid",void 0),__decorate([property({type:String,attribute:"return-url"})],DeleteButton.prototype,"returnUrl",void 0),__decorate([property({type:String,attribute:"modal-title"})],DeleteButton.prototype,"modalTitle",void 0),__decorate([property({type:String,attribute:"modal-content"})],DeleteButton.prototype,"modalContent",void 0),__decorate([property({type:String,attribute:"modal-button-ok"})],DeleteButton.prototype,"okButtonLabel",void 0),__decorate([property({type:String,attribute:"modal-button-cancel"})],DeleteButton.prototype,"cancelButtonLabel",void 0),DeleteButton=__decorate([customElement("typo3-sysnote-delete-button")],DeleteButton);export{DeleteButton};