/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{Collapse}from"bootstrap";import SecurityUtility from"@typo3/core/security-utility.js";import Modal from"@typo3/backend/modal.js";import RegularEvent from"@typo3/core/event/regular-event.js";import Severity from"@typo3/backend/severity.js";import{selector}from"@typo3/core/literals.js";import ClientStorage from"@typo3/backend/storage/client.js";var Selectors;!function(e){e.toggleSelector='[data-bs-toggle="flexform-inline"]',e.actionFieldSelector=".t3js-flex-control-action",e.controlSectionSelector=".t3js-formengine-irre-control",e.sectionContentContainerSelector=".t3js-flex-section-content",e.deleteContainerButtonSelector=".t3js-delete",e.contentPreviewSelector=".content-preview"}(Selectors||(Selectors={}));class FlexFormContainerContainer{constructor(e,t){this.securityUtility=new SecurityUtility,this.parentContainer=e,this.container=t,this.containerContent=t.querySelector(Selectors.sectionContentContainerSelector),this.parentId=t.dataset.parent,this.containerId=t.dataset.flexformContainerId,this.toggleKeyInLocalStorage=`formengine-flex-${e.getSectionContainer().id}-${this.containerId}-collapse`,this.panelHeading=t.querySelector(selector`[data-bs-target="#flexform-container-${this.containerId}"]`),this.panelButton=this.panelHeading.querySelector(selector`[aria-controls="flexform-container-${this.containerId}"]`),this.registerEvents()}static getCollapseInstance(e,t){return Collapse.getInstance(e)??new Collapse(e,{toggle:t})}getStatus(){return{id:this.containerId,collapsed:"false"===this.panelButton.getAttribute("aria-expanded")}}registerEvents(){this.parentContainer.isRestructuringAllowed()&&this.registerDelete(),this.registerPanelToggle(),this.registerToggle()}registerDelete(){new RegularEvent("click",(()=>{const e=TYPO3.lang["flexform.section.delete.title"]||"Delete this container?",t=TYPO3.lang["flexform.section.delete.message"]||"Are you sure you want to delete this container?",n=Modal.confirm(e,t,Severity.warning,[{text:TYPO3.lang["buttons.confirm.delete_record.no"]||"Cancel",active:!0,btnClass:"btn-default",name:"no"},{text:TYPO3.lang["buttons.confirm.delete_record.yes"]||"Yes, delete this container",btnClass:"btn-warning",name:"yes"}]);n.addEventListener("button.clicked",(e=>{if("yes"===e.target.name){const e=this.container.querySelector(Selectors.actionFieldSelector);e.value="DELETE",this.container.appendChild(e),this.container.classList.add("t3-flex-section--deleted"),this.container.classList.add("has-change"),new RegularEvent("transitionend",(()=>{this.container.classList.add("hidden");const e=new CustomEvent("formengine:flexform:container-deleted",{detail:{containerId:this.containerId}});this.parentContainer.getContainer().dispatchEvent(e)})).bindTo(this.container)}n.hideModal()}))})).bindTo(this.container.querySelector(Selectors.deleteContainerButtonSelector))}registerToggle(){const e="1"===(ClientStorage.get(this.toggleKeyInLocalStorage)??"1"),t=FlexFormContainerContainer.getCollapseInstance(this.containerContent,!e);this.generatePreview(),new RegularEvent("click",(()=>{t.toggle()})).delegateTo(this.container,`${Selectors.toggleSelector} .form-irre-header-cell:not(${Selectors.controlSectionSelector}`)}registerPanelToggle(){["hide.bs.collapse","show.bs.collapse"].forEach((e=>{new RegularEvent(e,(e=>{const t="hide.bs.collapse"===e.type;ClientStorage.set(this.toggleKeyInLocalStorage,t?"1":"0"),this.panelButton.setAttribute("aria-expanded",t?"false":"true"),this.panelButton.parentElement.classList.toggle("collapsed",t),this.generatePreview()})).bindTo(this.containerContent)}))}generatePreview(){let e="";if(this.getStatus().collapsed){const t=this.containerContent.querySelectorAll('input[type="text"], textarea');for(const n of t){let t=this.securityUtility.stripHtml(n.value);t.length>50&&(t=t.substring(0,50)+"..."),e+=(e?" / ":"")+t}}this.panelHeading.querySelector(Selectors.contentPreviewSelector).textContent=e}}export default FlexFormContainerContainer;