/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var ColumnSelectorButton_1,Selectors,SelectorActions,__decorate=function(t,e,o,l){var r,n=arguments.length,c=n<3?e:null===l?l=Object.getOwnPropertyDescriptor(e,o):l;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)c=Reflect.decorate(t,e,o,l);else for(var s=t.length-1;s>=0;s--)(r=t[s])&&(c=(n<3?r(c):n>3?r(e,o,c):r(e,o))||c);return n>3&&c&&Object.defineProperty(e,o,c),c};import{html,css,LitElement}from"lit";import{customElement,property}from"lit/decorators.js";import{SeverityEnum}from"@typo3/backend/enum/severity.js";import Severity from"@typo3/backend/severity.js";import{default as Modal}from"@typo3/backend/modal.js";import{lll}from"@typo3/core/lit-helper.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import Notification from"@typo3/backend/notification.js";!function(t){t.columnsSelector=".t3js-column-selector",t.columnsContainerSelector=".t3js-column-selector-container",t.columnsFilterSelector='input[name="columns-filter"]',t.columnsSelectorActionsSelector=".t3js-column-selector-actions"}(Selectors||(Selectors={})),function(t){t.toggle="select-toggle",t.all="select-all",t.none="select-none"}(SelectorActions||(SelectorActions={}));let ColumnSelectorButton=ColumnSelectorButton_1=class extends LitElement{constructor(){super(),this.modalTitle="Show columns",this.buttonOk=lll("button.ok")||"Update",this.buttonClose=lll("button.close")||"Close",this.errorMessage="Could not update columns",this.addEventListener("click",(t=>{t.preventDefault(),this.showColumnSelectorModal()})),this.addEventListener("keydown",(t=>{"Enter"!==t.key&&" "!==t.key||(t.preventDefault(),this.showColumnSelectorModal())}))}static toggleSelectorActions(t,e,o,l=!1){e.classList.add("disabled");for(let o=0;o<t.length;o++)if(!t[o].disabled&&!t[o].checked&&(l||!ColumnSelectorButton_1.isColumnHidden(t[o]))){e.classList.remove("disabled");break}o.classList.add("disabled");for(let e=0;e<t.length;e++)if(!t[e].disabled&&t[e].checked&&(l||!ColumnSelectorButton_1.isColumnHidden(t[e]))){o.classList.remove("disabled");break}}static isColumnHidden(t){return t.closest(Selectors.columnsContainerSelector)?.classList.contains("hidden")}static filterColumns(t,e){e.forEach((e=>{const o=e.closest(Selectors.columnsContainerSelector);if(!e.disabled&&null!==o){const e=o.querySelector(".form-check-label")?.textContent;e&&e.length&&o.classList.toggle("hidden",""!==t.value&&!RegExp(t.value,"i").test(e.trim().replace(/\[\]/g,"").replace(/\s+/g," ")))}}))}connectedCallback(){this.hasAttribute("role")||this.setAttribute("role","button"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0")}render(){return html`<slot></slot>`}showColumnSelectorModal(){if(!this.modalUrl||!this.modalTarget)return;const t=Modal.advanced({content:this.modalUrl,title:this.modalTitle,severity:SeverityEnum.notice,size:Modal.sizes.medium,type:Modal.types.ajax,buttons:[{text:this.buttonClose,active:!0,btnClass:"btn-default",name:"cancel",trigger:(t,e)=>e.hideModal()},{text:this.buttonOk,btnClass:"btn-"+Severity.getCssClass(SeverityEnum.info),name:"update",trigger:(t,e)=>this.processSelection(e)}],ajaxCallback:()=>this.handleModalContentLoaded(t)})}processSelection(t){const e=t.querySelector("form");null!==e?new AjaxRequest(TYPO3.settings.ajaxUrls.show_columns).post(new FormData(e)).then((async t=>{const e=await t.resolve();!0===e.success?(this.ownerDocument.location.href=this.modalTarget,this.ownerDocument.location.reload()):Notification.error(e.message||"No update was performed"),Modal.dismiss()})).catch((()=>{this.abortSelection()})):this.abortSelection()}handleModalContentLoaded(t){const e=t.querySelector("form");if(null===e)return;e.addEventListener("submit",(t=>{t.preventDefault()}));const o=t.querySelectorAll(Selectors.columnsSelector),l=t.querySelector(Selectors.columnsFilterSelector),r=t.querySelector(Selectors.columnsSelectorActionsSelector),n=r.querySelector('button[data-action="'+SelectorActions.all+'"]'),c=r.querySelector('button[data-action="'+SelectorActions.none+'"]');o.length&&null!==l&&null!==n&&null!==c&&(ColumnSelectorButton_1.toggleSelectorActions(o,n,c,!0),o.forEach((t=>{t.addEventListener("change",(()=>{ColumnSelectorButton_1.toggleSelectorActions(o,n,c)}))})),l.addEventListener("keydown",(t=>{const e=t.target;"Escape"===t.code&&(t.stopImmediatePropagation(),e.value="")})),l.addEventListener("keyup",(t=>{ColumnSelectorButton_1.filterColumns(t.target,o),ColumnSelectorButton_1.toggleSelectorActions(o,n,c)})),l.addEventListener("search",(t=>{ColumnSelectorButton_1.filterColumns(t.target,o),ColumnSelectorButton_1.toggleSelectorActions(o,n,c)})),r.querySelectorAll("button[data-action]").forEach((t=>{t.addEventListener("click",(t=>{t.preventDefault();const e=t.currentTarget;if(e.dataset.action){switch(e.dataset.action){case SelectorActions.toggle:o.forEach((t=>{t.disabled||ColumnSelectorButton_1.isColumnHidden(t)||(t.checked=!t.checked)}));break;case SelectorActions.all:o.forEach((t=>{t.disabled||ColumnSelectorButton_1.isColumnHidden(t)||(t.checked=!0)}));break;case SelectorActions.none:o.forEach((t=>{t.disabled||ColumnSelectorButton_1.isColumnHidden(t)||(t.checked=!1)}));break;default:Notification.warning("Unknown selector action")}ColumnSelectorButton_1.toggleSelectorActions(o,n,c)}}))})))}abortSelection(){Notification.error(this.errorMessage),Modal.dismiss()}};ColumnSelectorButton.styles=[css`:host { cursor: pointer; appearance: button; }`],__decorate([property({type:String,attribute:"data-url"})],ColumnSelectorButton.prototype,"modalUrl",void 0),__decorate([property({type:String,attribute:"data-target"})],ColumnSelectorButton.prototype,"modalTarget",void 0),__decorate([property({type:String,attribute:"data-title"})],ColumnSelectorButton.prototype,"modalTitle",void 0),__decorate([property({type:String,attribute:"data-button-ok"})],ColumnSelectorButton.prototype,"buttonOk",void 0),__decorate([property({type:String,attribute:"data-button-close"})],ColumnSelectorButton.prototype,"buttonClose",void 0),__decorate([property({type:String,attribute:"data-error-message"})],ColumnSelectorButton.prototype,"errorMessage",void 0),ColumnSelectorButton=ColumnSelectorButton_1=__decorate([customElement("typo3-backend-column-selector-button")],ColumnSelectorButton);export{ColumnSelectorButton};